<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Set up logging
$logFile = 'survey_logs.log';
function logMessage($message, $logFile) {
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

include "connect.php";

$response = [
    'success' => false,
    'message' => '',
    'data' => null
];

logMessage("Starting survey data processing", $logFile);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        logMessage("POST request received", $logFile);
        
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (empty($input)) {
            throw new Exception('No data received');
        }
        
        logMessage("Input data received: " . json_encode($input), $logFile);

        $propertyData = [
            // Property Information
            'propertyType' => null,
            'propertySituation' => null,
            'propertyAccessibility' => null,
            'propertyImagePath' => null,
            'propertyLatitude' => null,
            'propertyLongitude' => null,
            'propertyEasting' => null,
            'propertyNorthings' => null,
            'propertyAltitude'  => null,
            'propertyAccuracyRadius' => null,
            'propertyComments'      => null,
            'hasBorehole'  => null,
            'currentSrcOfWater' => null,
            'comments' => null,
            'dateCaptured'  => null, 
            
            'otherQuiz'     => null,
            'isNew' => null,
            'surveyID' => null,
            'startDateTime' => null,
            'endDateTime' => null,
            'dateSynced' => null,
            'surveyorID'     => null,
            'otherSpecifyComment' => null,
            
            // Account Information
            'accountName' => null,
            'accountNumber' => null,
            'plotNumber' => null,
            'mobileNo' => null,
            'emailAddress' => null,
            'pin' => null,
            'physicalAddress' => null,
            'identificationType' => null,
            'identificationNumber' => null,
            'propertyOwnershipType' => null,
            
            // Meter Information
            'meterSerialNumber' => null,
            'meterSerialNoVisibility' => null,
            'isMeterSerialNumberVisible' => null,
            'meterStatusComments' => null,
            'meterReading' => null,
            'meterStatus' => null,
            'installationMethod' => null,
            'meterInstallationComments' => null,
            'meterLocation' => null,
            'meterPosition' => null,
            'meterPositionComments' => null,
            'meterLatitude' => null,
            'meterLongitude' => null,
            'meterEasting' => null,
            'meterNorthings' => null,
            'meterAltitude' => null,
            'meterAccuracyRadius' => null,
            'meterImagePath' => null,
            'otherIdentificationComment' => null,

            // Potential Customers
            'potentialCustomerName' => null,
            'potentialCustomerPhoneNumber' => null,
            'potentialCustomerEmailAddress' => null,
            'potentialCustomerPhysicalAddress' => null,
            'potentialCustomerLatitude' => null,
            'potentialCustomerLongitude' => null,

            // borehole Information
            'boreholeMeterSerialNumber' => null,
            'boreholeMeterReading' => null,
            'boreholeMeterStatus' => null,
            'boreholeInstallationMethod' => null,
            'boreholeMeterLocation' => null,
            'boreholeMeterPosition' => null,
            'boreholeMeterLatitude' => null,
            'boreholeMeterLongitude' => null,
            'boreholeMeterImagePath' => null,
            'boreholeComments' => null,
  
            // Connection Information
            'connectionStatus' => null,
            'serviceType' => null,
            'customerCategoryTariff' => null,
            'numberOfUnits' => null,
            'sanitationType' => null,
            'disconnectionDate' => null,
            'reasonsForDisconnection' => null,
            'currentSourceOfWater' => null,
            'reconnectionWillingness' => null,
            'notedIllegalities' => null,
            'waterBurstIllegality' => null,
            'illegalConnection' => null,

            
            // Billing and Service Feedback
            'lastTimeBillReceived' => null,
            'billingDeliveryMethod' => null,
            'generalQuestion' => null,
            'waterQuality' => null,
            'otherQualityComments' => null,
            'waterSupplyFrequency' => null,
            
            // Status for identifying Business unit
            'businessUnit' =>null
        ];

        logMessage("Processing input data", $logFile);
        foreach ($input as $key => $value) {
            if (array_key_exists($key, $propertyData)) {
                if (is_bool($value)) {
                    $propertyData[$key] = $value ? 1 : 0;
                } elseif (isset($value)) {
                    $propertyData[$key] = $value;
                }
            }
        }

        $columns = array_keys($propertyData);
        $values = array_fill(0, count($columns), '?');
        $types = str_repeat('s', count($columns));
        $params = array_values($propertyData);

        $sql = "INSERT INTO uploaded_survey_data (" . implode(', ', $columns) . ") 
                VALUES (" . implode(', ', $values) . ")";
        
        logMessage("Preparing SQL statement: $sql", $logFile);
        $stmt = $conn->prepare($sql);
        
        if (!$stmt) {
            $error = 'Prepare failed: ' . $conn->error;
            logMessage($error, $logFile);
            throw new Exception($error);
        }

        logMessage("Binding parameters", $logFile);
        $stmt->bind_param($types, ...$params);
        
        logMessage("Executing statement", $logFile);
        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Property data saved successfully';
            $response['data'] = ['id' => $stmt->insert_id];
            http_response_code(201);
            logMessage("Survey data saved successfully. Insert ID: " . $stmt->insert_id, $logFile);
        } else {
            $error = 'Failed to save property data: ' . $stmt->error;
            logMessage($error, $logFile);
            throw new Exception($error);
        }
        
        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
        http_response_code(400);
        logMessage("Error: " . $e->getMessage(), $logFile);
    }
} else {
    $response['message'] = 'Invalid request method';
    http_response_code(405);
    logMessage("Invalid request method: " . $_SERVER['REQUEST_METHOD'], $logFile);
}

logMessage("Sending response: " . json_encode($response), $logFile);
echo json_encode($response);

$conn->close();
logMessage("Database connection closed", $logFile);
?>