<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');
$imageDir = __DIR__ . '/surveyCapturedImages/capturedImages/';

$allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];
$imageCount = 0;

if (!file_exists($imageDir)) {
    echo json_encode(['error' => 'Directory does not exist: ' . $imageDir]);
    exit;
}

$files = scandir($imageDir);
foreach ($files as $file) {
    if ($file === '.' || $file === '..') continue;
    $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
    if (in_array($ext, $allowedExtensions)) {
        $imageCount++;
    }
}

echo json_encode([
    'count' => $imageCount,
    'files_scanned' => $files
]);
?>