<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include "connect.php";

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    http_response_code(200);
    exit();
}

if ($_SERVER["REQUEST_METHOD"] !== "DELETE") {
    die(json_encode(["status" => "error", "message" => "Invalid request method"]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['empID'])) {
    die(json_encode(["status" => "error", "message" => "Missing required field: empID"]));
}

$stmt = $conn->prepare("DELETE FROM users WHERE empID = ?");

$stmt->bind_param("s", $postData['empID']);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Employee deleted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
