<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}


include 'connect.php';

$data = json_decode(file_get_contents("php://input"));
$accountNumber = $data->accountNumber;

try {
    $stmt = $conn->prepare("CALL MergeAndCheckData(?)");
    $stmt->bind_param("s", $accountNumber);
    $stmt->execute();
    
    echo json_encode([
        "success" => true,
        "message" => "Anomaly detection completed"
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error detecting anomalies: " . $e->getMessage()
    ]);
}

$conn->close();
?>