<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'connect.php';

$accountNumber = $_GET['accountNumber'] ?? '';

try {
    $sql = "SELECT * FROM data_anomalies WHERE accountNumber = ? AND verified = 0 ORDER BY anomalyDate DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $accountNumber);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $anomalies = [];
    while ($row = $result->fetch_assoc()) {
        $anomalies[] = $row;
    }
    
    echo json_encode([
        "success" => true,
        "anomalies" => $anomalies
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching anomalies: " . $e->getMessage()
    ]);
}

$conn->close();
?>