<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
include "connect.php";

$surveyorID = isset($_GET['surveyorID']) ? $_GET['surveyorID'] : null;

if (!$surveyorID) {
    http_response_code(400);
    echo json_encode(["error" => "surveyorID parameter is required"]);
    exit;
}

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

$query = "
    SELECT COUNT(*) as count 
    FROM customer_assignment 
    WHERE surveyorID = ?
    AND uploadStatus = '0'
";

$stmt = $conn->prepare($query);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(["error" => "Prepare failed: " . $conn->error]);
    exit;
}

$stmt->bind_param("s", $surveyorID);
if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(["error" => "Execute failed: " . $stmt->error]);
    exit;
}

$result = $stmt->get_result();
if (!$result) {
    http_response_code(500);
    echo json_encode(["error" => "Get result failed: " . $stmt->error]);
    exit;
}

$row = $result->fetch_assoc();
echo json_encode(["count" => (int)$row['count']]);

$stmt->close();
$conn->close();
?>