<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'connect.php';

$uploadStatus = isset($_GET['uploadStatus']) ? $_GET['uploadStatus'] : null;
$role         = isset($_GET['role']) ? $_GET['role'] : null; 
$businessUnit = isset($_GET['businessUnit']) ? $_GET['businessUnit'] : null;

if ($uploadStatus === null) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "code" => 400,
        "message" => "uploadStatus parameter is required"
    ]);
    exit;
}

try {
    $sql = "
        SELECT ca.*, usd.businessUnit
        FROM customer_assignment ca
        JOIN uploaded_survey_data usd 
            ON ca.accountNo = usd.accountNumber
        WHERE ca.uploadStatus = ?
    ";

    $params = [$uploadStatus];
    $types  = "s";

    if ($role !== "Admin" && $businessUnit) {
        $sql .= " AND usd.businessUnit = ?";
        $params[] = $businessUnit;
        $types   .= "s";

        if ($role === "MowasscoTeam") {
            $sql .= " AND usd.verificationStatus = '1'";
        }
    }

    $sql .= " ORDER BY ca.dateAssigned DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    $customers = [];
    while ($row = $result->fetch_assoc()) {
        $customers[] = $row;
    }

    if (empty($customers)) {
        http_response_code(404);
        echo json_encode([
            "status" => "error",
            "code" => 404,
            "message" => "No customers found"
        ]);
    } else {
        http_response_code(200);
        echo json_encode([
            "status" => "success",
            "code" => 200,
            "data" => $customers
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "code" => 500,
        "message" => "Server error: " . $e->getMessage()
    ]);
}

$conn->close();
?>