<?php
header("Access-Control-Allow-Origin: *"); 
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include 'connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$query = "
SELECT 
    COUNT(*) AS total_customers,
    SUM(CASE WHEN uploadStatus = '1' THEN 1 ELSE 0 END) AS uploaded_customers,
    COUNT(DISTINCT CASE WHEN uploadStatus = '1' THEN zone END) AS total_zones,
    COUNT(DISTINCT CASE WHEN uploadStatus = '1' THEN surveyorID END) AS active_surveyors
FROM customer_assignment";

$result = mysqli_query($conn, $query);
$data = mysqli_fetch_assoc($result);

echo json_encode($data);
