<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include "connect.php";

$empID = $_GET['empID'] ?? null;

if (!$empID) {
    http_response_code(400);
    echo json_encode(["error" => "supervisorID parameter is required"]);
    exit;
}

try {
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM surveyor WHERE empID = ?");
    $stmt->bind_param("s", $empID);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    echo json_encode(["count" => (int)$result['count']]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
