<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}
include 'connect.php';

$input = file_get_contents('php://input');
$data = json_decode($input);

error_log("Received update request: " . print_r($data, true));

if(!empty($data->accountNumber) && !empty($data->fieldName) && isset($data->fieldValue)) {
    
    $allowedFields = [
        'mobileNo', 'serviceType', 'physicalAddress', 'identificationNumber',
        'plotNumber', 'meterSerialNumber', 'connectionStatus', 'meterStatus', 'propertyOwnershipType',
        'customerCategoryTariff', 'sanitationType', 'propertyAccessibility',
        'propertySituation', 'identificationType', 'installationMethod', 'meterReading',
        'meterPosition', 
    ];
    
    if (!in_array($data->fieldName, $allowedFields)) {
        http_response_code(400);
        echo json_encode(array("success" => false, "message" => "Invalid field name: " . $data->fieldName));
        exit();
    }
    
    $checkQuery = "SELECT accountNumber FROM uploaded_survey_data WHERE accountNumber = ?";
    $checkStmt = $conn->prepare($checkQuery);
    $checkStmt->bind_param("s", $data->accountNumber);
    $checkStmt->execute();
    $checkStmt->store_result();
    
    if ($checkStmt->num_rows === 0) {
        http_response_code(404);
        echo json_encode(array("success" => false, "message" => "Account not found: " . $data->accountNumber));
        $checkStmt->close();
        exit();
    }
    $checkStmt->close();
    
    $query = "UPDATE uploaded_survey_data SET " . $data->fieldName . " = ? WHERE accountNumber = ?";
    $stmt = $conn->prepare($query);
    
    if (!$stmt) {
        http_response_code(500);
        echo json_encode(array("success" => false, "message" => "Prepare failed: " . $conn->error));
        exit();
    }
    
    $stmt->bind_param("ss", $data->fieldValue, $data->accountNumber);
    
    if($stmt->execute()) {
        $affectedRows = $stmt->affected_rows;
        error_log("Update executed. Affected rows: " . $affectedRows);
        
        http_response_code(200);
        echo json_encode(array(
            "success" => true, 
            "message" => "Field updated successfully. Affected rows: " . $affectedRows,
            "data" => array(
                "accountNumber" => $data->accountNumber,
                "field" => $data->fieldName,
                "newValue" => $data->fieldValue,
                "affectedRows" => $affectedRows
            )
        ));
    } else {
        error_log("Update failed: " . $stmt->error);
        http_response_code(500);
        echo json_encode(array("success" => false, "message" => "Unable to update field: " . $stmt->error));
    }
    
    $stmt->close();
} else {
    http_response_code(400);
    echo json_encode(array("success" => false, "message" => "Incomplete data. Received: " . print_r($data, true)));
}

$conn->close();
?>