<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include 'connect.php';

$data = json_decode(file_get_contents("php://input"));
$anomalyId = $data->anomalyId;
$action = $data->action;
$verifiedBy = $data->verifiedBy;
$verificationDate = $data->verificationDate;

try {
    $stmt = $conn->prepare("UPDATE data_anomalies 
                           SET verified = 1, 
                               verification_action = ?,
                               verified_by = ?,
                               verification_date = ?
                           WHERE id = ?");
    $stmt->bind_param("sssi", $action, $verifiedBy, $verificationDate, $anomalyId);
    $stmt->execute();
    
    echo json_encode(["success" => true, "message" => "Anomaly verified"]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
}

$conn->close();
?>